function t = checkCoverage(edge_wwf, cs_corrected_wwfR_gray, fpi_pixel_contour, thresh)

% Used to prevent oversegmentation done by firing pin impression
% segmentation algorithm

%% input 
% edge_wwf : The outermost continuous edge of the region of interest
%            consisting of the breech face region, flowback and firing pin impression
% cs_corrected_wwfR_gray : illumination corrected registered/unregistered region of interest represented
%                          in grayscale taking values in the range 0-255
% fpi_pixel_contour : The fpi mask either from pixel or contour based
%                     strategy
% thresh : threshold value in the range 0 to 1
%% output
% t - binary output if 1 - then change needed in mask else no change
%     required

% Two Strategies
% Strategy 1 : Firing pin impression cannot be greater than thresh(i.e.80%) of
%              the entire region of interest of the cartridge case base.
%              The entire region of interest consists of the breech face
%              region, flowback and the firing pin impression
[xFP yFP]=find_logical(fpi_pixel_contour);
EJbw_fill=imfill(edge_wwf,'holes');
[xej yej ]=find_logical(EJbw_fill);

t=0;
if length(xFP)/length(xej)>=thresh
    t=1;
else
    t=0;
end

% Strategy 2 : If fpi has more than 20%(thresh2) interaction with the
% flowback calculated on BFgn then t=1;
%thresh2=(1-thresh);
thresh2=0.2;
if t==0
  ZZ=double(cs_corrected_wwfR_gray)>= mean(double(cs_corrected_wwfR_gray(:)))+std(double(cs_corrected_wwfR_gray(:)));
  [xzz yzz]=find_logical(ZZ);
  Bin = intersectRows([yzz xzz],[yFP xFP]);
  if isempty(Bin)==0
      A=size(Bin,1);
      B=size(xFP,1);
      if  A/B>=thresh2
          t=1;
      else
          t=0;
      end
  else
      t=0;
  end
end
    
end

